//
import flixel.tweens.FlxTween;
import flixel.text.FlxTextAlign;
import flixel.text.FlxTextBorderStyle;
import hxvlc.flixel.FlxVideoSprite;

if (FlxG.save.data.midsongvids_toggle) {
	camGreen = new FlxCamera(0, 0, 960, 720);
	FlxG.cameras.add(camGreen, false);
	camGreen.bgColor = FlxColor.TRANSPARENT;
	//
	var green:CustomShader = new CustomShader("NebulaGreenscreen");
	//
	var mlg = new FlxVideoSprite(0, 0);
	mlg.autoPause = false;
	mlg.load(Assets.getPath(Paths.video("mlg")));
	mlg.shader = green;
	// mlg.visible = false;
}
var introExplainTxt:FlxText;

function create() {
	if (FlxG.save.data.midsongvids_toggle) {
		FlxG.cameras.remove(camHUD, false);
		FlxG.cameras.add(camHUD, false);
		mlg.bitmap.onFormatSetup.add(function() {
			mlg.cameras = [camGreen];
			mlg.scale.set(1.5, 1.5);
			mlg.updateHitbox();
		});
		add(mlg);
	}
}

/**
 * All video variables should be declared in this array, otherwise the custom focus handler
 * won't happen, and weird behaviour might happen.
 */
 var videosToHandle:Array<FlxVideoSprite> = [mlg];

function onSubstateOpen() {
	// check: should we be playing a video?
	// if yes: pause all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.pause();
			}
		}
	}
}

function onSubstateClose() {
	// check: should we be playing a video?
	// if yes: resume all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.resume();
			}
		}
	}
}

/** NOTE for: onFocusLost() | onFocus()
 * Since hxvlc.flixel.FlxVideo/FlxVideoSprite doesn't have an "isPlaying" variable, we
 * check if the video is visible instead. If it isn't, then the video shouldn't be
 * playing in the first place.								~ xavi. (thatoneidiotxav)
**/
function onFocusLost() {
	// check: should we be playing a video?
	// if yes: run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		// if yes: pause video
		// otherwise: do nothing, videos should already be paused
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.pause();
				}
			}
		}
	}
}

function onFocus() {
	// check: should we be playing a video?
	// if yes, run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.resume();
				}
			}
		}
	}
}

function postCreate() {
	introExplainTxt = new FlxText(0, 0, 0, "sanic really luvs his (intervention) sniper rifle !!\nyou should try dodging his n0scop3s with the space bar", 40);
	introExplainTxt.setFormat(Paths.font('comic.ttf'), 32, 0xFFFFFFFF, null, FlxTextBorderStyle.OUTLINE, 0xFF000000);
	introExplainTxt.cameras = [camHUD2];
	introExplainTxt.alignment = FlxTextAlign.CENTER;
	introExplainTxt.screenCenter();
	introExplainTxt.alpha = 0.001;
	add(introExplainTxt);
	camHUD.visible = false;
}

function stepHit(step:Int) {
	switch (step) {
		case 64:
			FlxTween.tween(introExplainTxt, {alpha: 1}, 1, {ease: FlxEase.quadOut});
		case 112:
			FlxTween.tween(introExplainTxt, {alpha: 0.001, y: FlxG.height + 50}, 1, {ease: FlxEase.quadOut});
		case 128:
			introExplainTxt.destroy();
			camHUD.visible = true;
		case 896:
			if (FlxG.save.data.midsongvids_toggle && FlxG.save.data.flashing_toggle) {
				mlg.visible = true;
				mlg.play();
			}
		case 1176:
			if (FlxG.save.data.midsongvids_toggle) {
				mlg.visible = false;
				remove(mlg);
			}
	}
}
